import funclib            # funclib.py must be in same directory as this test script

def test_get_input_as_int():
    x = funclib.get_input_as_int('5')

    assert x == 5

    try:
        funclib.get_input_as_int('what?')
    except ValueError:
        pass
    else:
        raise AssertionError("get_input_as_int('what') does not raise a ValueError")


def test_file_count():
    lines, words, chars = funclib.file_count('FF_tiny.txt')

    assert lines == 9

    assert words == 45

    assert chars == 368

    lines = funclib.file_count('FF_tiny.txt', items='l')
    assert lines == 9

    words = funclib.file_count('FF_tiny.txt', items='w')
    assert words == 45

    chars = funclib.file_count('FF_tiny.txt', items='c')
    assert chars == 368


    try:
        funclib.file_count('FF_tiny.txt', items='xxx')
    except ValueError:
        pass
    else:
        raise AssertionError('file_count(items=\'xxx\') did NOT raise ValueError')


def test_get_lookup_dict():
    ret = funclib.get_lookup_dict('pac_man_ghosts.csv')
    assert ret == {'Shadow': 'Blinky', 'Speedy': 'Pinky', 'Bashful': 'Inky', 'Pokey': 'Clyde'}
    ret = funclib.get_lookup_dict('boropop2020.csv')
    assert ret == {'Bronx': '1472654',
                   'Brooklyn': '2736074',
                   'Manhattan': '1694251',
                   'Queens': '2405464',
                   'Richmond': '495747'}

